﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework.Input;
using CashierCrisis.Managers;
using System.Diagnostics;
using Microsoft.Xna.Framework.Graphics;

namespace CashierCrisis.Entities
{
    public class InputComponent : Component
    {
        InputManager input;
        private readonly float COS_SIN_45;
        //private int stamina = 1000;
        public int MovementSpeed { get; set; }
        //private StatusBarComponent statusBar;

        public InputComponent(string name)
            :base(name)
        {
            input = CashierGame.Instance.Services.GetService(typeof(InputManager)) as InputManager;
            MovementSpeed = 7;
            COS_SIN_45 = (float)Math.Cos(45);
        }

        // Movement methods.
        public void MoveUp()
        {
            Entity.Position.Y = Entity.Position.Y - (COS_SIN_45 * MovementSpeed);
        }

        public void MoveDown()
        {
            Entity.Position.Y = Entity.Position.Y + (COS_SIN_45 * MovementSpeed);
        }

        public void MoveLeft()
        {
            Entity.Position.X = Entity.Position.X - (COS_SIN_45 * MovementSpeed);
        }

        public void MoveRight()
        {
            Entity.Position.X = Entity.Position.X + (COS_SIN_45 * MovementSpeed);
        }

       
        // Keyboard Input.
        public void UpdateKeyboardInput()
        {
            if(input.IsKeyPressed(Keys.Up))
            {
                MoveUp();
            }

            if(input.IsKeyPressed(Keys.Down))
            {
                MoveDown();
            }

            if(input.IsKeyPressed(Keys.Left))
            {
                MoveLeft();
            }

            if(input.IsKeyPressed(Keys.Right))
            {
                MoveRight();
            }



        
        }

  

        public override void Update(Microsoft.Xna.Framework.GameTime gameTime)
        {

#if !XBOX
            UpdateKeyboardInput();
#endif

            //Gamepad Input.
            if (input.IsButtonPressed(Buttons.LeftThumbstickUp))
            {
                MoveUp();
            }

            if (input.IsButtonPressed(Buttons.LeftThumbstickLeft))
            {
                MoveLeft();
            }

            if (input.IsButtonPressed(Buttons.LeftThumbstickRight))
            {
                MoveRight();
            }

            if (input.IsButtonPressed(Buttons.LeftThumbstickDown))
            {
                MoveDown();
            }


        }

        public override void OnAttached(Entity entity)
        {
            base.OnAttached(entity);
        }
    }
}
